-- Copyright (c) 2019 Darren Watts
-- Some of this code was taken from Jeremiah Morris's HUD code.
-- If anything here is useful to other people, feel free to include it in other scripts.

Triggers = {}

function Triggers.init()
    int_fonts = {}
    for ftype in InterfaceFonts() do
        int_fonts[ftype.mnemonic] = Fonts.new {interface = ftype}
    end

    imgs = {}
    imgs["interface panel"] = Images.new {resource = 1700}

    for idx, name in ipairs(
        {
            "empty life bar",
            "life bar",
            "life bar right",
            "poison bar",
            "poison bar right",
            "triple life bar",
            "triple life bar right",
            "empty oxygen bar",
            "oxygen bar",
            "oxygen bar right"
        }
    ) do
        imgs[name] = Shapes.new {collection = 0, texture_index = idx - 1, type = TextureTypes["interface"]}
    end

    img_rat_from_left = create_image("hud_files/rat_from_left.png", Screen.height / 4.5)
    img_rat_from_right = create_image("hud_files/rat_from_right.png", Screen.height / 4.5)
    img_rat_from_left2 = create_image("hud_files/rat_from_left2.png", Screen.height / 4.5)
    img_rat_from_right2 = create_image("hud_files/rat_from_right2.png", Screen.height / 4.5)
    img_frog_from_left = create_image("hud_files/frog_from_left.png", Screen.height / 2.5)
    img_frog_from_right = create_image("hud_files/frog_from_right.png", Screen.height / 2.5)
    rat_created_tick = 0
    frog_created_tick = 0

    img_legend = Images.new {path = "hud_files/legend.png"}

    item_images = {}
    local i = nil
    for i = 1, 58 do
        local path = "hud_files/items/" .. i .. ".png"
        item_images[i] = Images.new {path = path}
    end

    end_images = {}
    for i = 1, 6 do
        local path = "hud_files/score/End" .. i .. ".png"
        end_images[i] = Images.new {path = path}
    end

    end_animation_images = {}
    for i = 1, 6 do
        local path = "hud_files/end_animation/end_animation_" .. i .. ".png"
        end_animation_images[i] = Images.new {path = path}
    end

    score_image = Images.new {path = "hud_files/score/score.png"}

    rats = {}
    frogs = {}

    has_reached_end_screen = false
    end_screen_start = -1

    Triggers.resize()
end

function create_image(p, height)
    local img = Images.new {path = p}
    ratio = height / img.height
    width = img.width * ratio
    img:rescale(width, height)
    return img
end

function Triggers.draw()
    if Level.index == 25 then -- End screen stuff
        if not has_reached_end_screen then
            end_screen_start = Game.ticks
            has_reached_end_screen = true
        end
        if has_reached_end_screen then
            handle_ending()
        end
    else
        selected_crystal = get_crystal_name(get_stashed_num("selected_crystal_id"))
        max_health = get_stashed_num("max_health")

        -- health bar
        globals.font:draw_text("Health", Screen.width - adj(191) - 10 - adj(40), 10, get_font_color())
        local max_life = 150

        local r = {}
        r.x = Screen.width - adj(191) - 10
        r.y = 10
        r.width = adj(191)
        r.height = adj(14)

        local poisoned = false
        if get_stashed("poisoned") then
            poisoned = true
        end

        if poisoned then
            draw_bar(
                r,
                math.max(Player.life, 0) / max_life,
                imgs["poison bar right"],
                imgs["poison bar"],
                imgs["empty life bar"],
                max_health
            )
        else
            draw_bar(
                r,
                math.max(Player.life, 0) / max_life,
                imgs["life bar right"],
                imgs["life bar"],
                imgs["empty life bar"],
                max_health
            )
        end

        -- oxygen
        globals.font:draw_text(
            "Power",
            Screen.width - adj(191) - 10 - adj(40),
            10 + adj(14) + adj(10),
            get_font_color()
        )
        local max_oxygen = 6 * 30 * 60

        r = {}
        r.x = Screen.width - adj(191) - 10
        r.y = 10 + adj(14) + adj(10)
        r.width = adj(191)
        r.height = adj(14)

        draw_bar(
            r,
            math.max(Player.oxygen, 0) / max_oxygen,
            imgs["oxygen bar right"],
            imgs["oxygen bar"],
            imgs["empty oxygen bar"]
        )

        -- current crystal
        if selected_crystal then
            globals.font:draw_text(
                selected_crystal,
                right_align_adj(selected_crystal, Screen.width - 10),
                10 + adj(14) + adj(10) + adj(14) + adj(2),
                get_font_color()
            )
        end

        -- current weapon
        if Player.weapons.current then
            local weapon_name = get_weapon_name()
            globals.font:draw_text(
                weapon_name,
                Screen.width - adj(191) - 10 - adj(40),
                10 + adj(14) + adj(10) + adj(14) + adj(2) + adj(14),
                get_font_color()
            )

            if Player.weapons.current.type ~= "fist" then
                local ammo_name = get_ammo_name(Player.weapons.current.type)
                text =
                    ammo_name ..
                    " " ..
                        Player.weapons.current.primary.rounds ..
                            "/" ..
                                Player.weapons.current.primary.total_rounds ..
                                    " (x" .. get_magazine_count(Player.weapons.current) .. ")"

                globals.font:draw_text(
                    text,
                    Screen.width - adj(191) - 10 - adj(40),
                    10 + adj(14) + adj(10) + adj(14) + adj(2) + adj(30),
                    get_font_color()
                )
            end
        end

        if get_stashed("spawn_rat") and rat_created_tick ~= Game.ticks then -- spawn a new rat
            rat_created_tick = Game.ticks
            local left = math.random(2) == 1
            local y = (Screen.height / 8) + math.random(Screen.height - (.25 * Screen.height))

            if left then
                x = 0 - img_rat_from_left.width
            else
                x = Screen.width + img_rat_from_left.width
            end
            local rat = {left = left, x = x, y = y, permutation = math.random(2), moved_tick = Game.ticks - 1}
            table.insert(rats, rat)
        end

        if get_stashed("spawn_frog") and frog_created_tick ~= Game.ticks then -- spawn a new frog
            frog_created_tick = Game.ticks
            local left = math.random(2) == 1
            local y = (Screen.height / 6) + math.random(Screen.height - (.33 * Screen.height))

            if left then
                x = 0 - img_frog_from_left.width
            else
                x = Screen.width + img_frog_from_left.width
            end
            local frog = {left = left, x = x, y = y, moved_tick = Game.ticks - 1}
            table.insert(frogs, frog)
        end

        -- Rats
        local remove = -1
        for i = 1, #rats do
            local rat = rats[i]
            local img = nil
            if rat.left then
                if rat.moved_tick ~= Game.ticks then
                    rat.moved_tick = Game.ticks
                    rat.x = rat.x + (Screen.width / 15)
                end
                if rat.permutation == 1 then
                    img = img_rat_from_left
                else
                    img = img_rat_from_left2
                end
            else
                if rat.moved_tick ~= Game.ticks then
                    rat.moved_tick = Game.ticks
                    rat.x = rat.x - (Screen.width / 15)
                end
                if rat.permutation == 1 then
                    img = img_rat_from_right
                else
                    img = img_rat_from_right2
                end
            end
            img:draw(rat.x, rat.y)
            if rat.x > Screen.width + img.width then
                remove = i
            end
        end

        if remove > 0 then
            table.remove(rats, remove)
        end

        -- Frogs
        remove = -1
        for i = 1, #frogs do
            local frog = frogs[i]
            local img = nil
            if frog.left then
                if frog.moved_tick ~= Game.ticks then
                    frog.moved_tick = Game.ticks
                    frog.x = frog.x + (Screen.width / 15)
                end
                img = img_frog_from_left
            else
                if frog.moved_tick ~= Game.ticks then
                    frog.moved_tick = Game.ticks
                    frog.x = frog.x - (Screen.width / 15)
                end
                img = img_frog_from_right
            end
            img:draw(frog.x, frog.y)
            if frog.x > Screen.width + img.width then
                remove = i
            end
        end

        if remove > 0 then
            table.remove(frogs, remove)
        end

        -- selected inventory item
        local img = item_images[get_stashed_num("inventory_item_id")]
        if img then
            local x = (Screen.width / 2) - (img.width / 2)
            local y = 60
            img:draw(x, y)
        end

        -- Legend and full ammo display when map is active
        if Screen.map_active then
            img_legend:draw(Screen.width - 94, Screen.height - 259)

            local ammo_y = 10 + adj(14) + adj(10) + adj(14) + adj(25) + adj(50)

            ammo_y = draw_ammo_amount("pistol", get_ammo_name("pistol"), ammo_y)
            ammo_y = draw_ammo_amount("smg", get_ammo_name("smg"), ammo_y)
            ammo_y = draw_ammo_amount("fusion pistol", get_ammo_name("fusion pistol"), ammo_y)
            ammo_y = draw_ammo_amount("flamethrower", get_ammo_name("flamethrower"), ammo_y)
            ammo_y = draw_ammo_amount("missile launcher", get_ammo_name("missile launcher"), ammo_y)
            ammo_y = draw_ammo_amount("assault rifle", get_ammo_name("assault rifle"), ammo_y)
            ammo_y = draw_ammo_amount("shotgun", get_ammo_name("shotgun"), ammo_y)
            ammo_y = draw_ammo_amount("alien weapon", get_ammo_name("alien weapon"), ammo_y)
        end
    end
end

function draw_ammo_amount(weapon_name, ammo_name, ammo_y)
    local ammo_count = get_magazine_count(Player.weapons[weapon_name])
    if ammo_count > 0 then
        local text = ammo_name .. " (x" .. ammo_count .. ")"

        globals.font:draw_text(text, Screen.width - adj(191) - 10 - adj(40), ammo_y, get_font_color())
        ammo_y = ammo_y + adj(15)
    end

    return ammo_y
end

function get_font_color()
    if Screen.map_active then
        return {1, .2, .2, 1}
    else
        return {1, 1, 1, 1}
    end
end

function draw_bar(r, frac, cap, full, empty, total_val)
    empty.crop_rect.width = r.width
    empty.crop_rect.height = r.height
    empty:draw(r.x, r.y)

    if total_val then
        local health_ratio = Player.life / 150
        local current_health = math.max(get_stashed_num("current_health"), 0)

        local text = string.format("%.1f", current_health / 10) .. " of " .. math.floor(total_val / 10)
        local w, _ = globals.font:measure_text(text)
        globals.font:draw_text(text, (Screen.width - 15) - w, r.y + 1, {1, 1, 1, 1})
    end

    local width = r.width * frac
    local cap_width = globals.cap_width

    if width > 2 * cap_width then
        cap:rescale(adj(8), adj(14))
        cap.crop_rect.width = cap_width
        cap.crop_rect.height = r.height
        cap.crop_rect.x = 0
        cap:draw(r.x + width - cap_width, r.y)

        full:rescale(adj(191), adj(14))
        full.crop_rect.width = width - cap_width
        full.crop_rect.height = r.height
        full:draw(r.x, r.y)
    else
        cap:rescale(adj(8), adj(14))
        cap.crop_rect.width = width / 2
        cap.crop_rect.height = r.height
        cap.crop_rect.x = cap_width - width / 2
        cap:draw(r.x + width / 2, r.y)

        full:rescale(adj(191), adj(14))
        full.crop_rect.width = width / 2
        full.crop_rect.height = r.height
        full:draw(r.x, r.y)
    end
end

function get_weapon_name()
    local weapon = Player.weapons.current
    if weapon.type == "fist" then
        return "Survival Knife"
    elseif weapon.type == "pistol" then
        return "Walther P4 Pistol"
    elseif weapon.type == "fusion pistol" then
        return "M-79 Grenade Launcher"
    elseif weapon.type == "assault rifle" then
        return "AK-47 Assault Rifle"
    elseif weapon.type == "missile launcher" then
        return "M-79 Grenade Launcher"
    elseif weapon.type == "flamethrower" then
        return "M-79 Grenade Launcher"
    elseif weapon.type == "alien weapon" then
        return "AK-47 Assault Rifle"
    elseif weapon.type == "shotgun" then
        return "AK-47 Assault Rifle"
    elseif weapon.type == "smg" then
        return "MP-41 Submachine Gun"
    end
end

function get_ammo_name(type)
    if type == "pistol" then
        return "Walther P4 Magazine"
    elseif type == "fusion pistol" then
        return "40mm Projectile Cartridge"
    elseif type == "assault rifle" then
        return "AK-47 Magazine"
    elseif type == "missile launcher" then
        return "40mm HE Cartridge"
    elseif type == "flamethrower" then
        return "40mm Fragmentation Cartridge"
    elseif type == "alien weapon" then
        return "AK-47 HE Magazine"
    elseif type == "shotgun" then
        return "AK-47 SABOT Magazine"
    elseif type == "smg" then
        return "MP-41 Magazine"
    end
end

function get_crystal_name(id)
    if id == 11 then
        return "Black Crystal"
    elseif id == 12 then
        return "Blue Crystal"
    elseif id == 29 then
        return "Green Crystal"
    elseif id == 39 then
        return "Orange Crystal"
    elseif id == 51 then
        return "Violet Crystal"
    elseif id == 54 then
        return "Yellow Crystal"
    else
        return nil
    end
end

function get_magazine_count(weapon)
    -- local weapon = Player.weapons.current
    if weapon.type == "pistol" then
        return Player.items["pistol ammo"].count
    elseif weapon.type == "fusion pistol" then
        return Player.items["fusion pistol ammo"].count
    elseif weapon.type == "assault rifle" then
        return Player.items["assault rifle ammo"].count
    elseif weapon.type == "missile launcher" then
        return Player.items["missile launcher ammo"].count
    elseif weapon.type == "flamethrower" then
        return Player.items["flamethrower ammo"].count
    elseif weapon.type == "alien weapon" then
        return Player.items["assault rifle grenades"].count
    elseif weapon.type == "shotgun" then
        return Player.items["shotgun ammo"].count
    elseif weapon.type == "smg" then
        return Player.items["smg ammo"].count
    end
end

function Triggers.resize()
    Screen.world_rect.width = Screen.width
    Screen.world_rect.height = Screen.height

    local font = nil
    if
        Screen.hud_size_preference == SizePreferences["double"] or
            Screen.hud_size_preference == SizePreferences["largest"]
     then
        font = Fonts.new {size = 20}
    else
        font = Fonts.new {size = 10}
    end

    local i
    for i = 1, 58 do
        local img = item_images[i]
        local ratio = img.height / img.width
        local new_width = Screen.width / 3
        local new_height = new_width * ratio
        img:rescale(new_width, new_height)
    end

    -- recalculate globals
    globals = {
        font = font,
        cap_width = adj(8)
    }
end

function adj(len)
    local size = Screen.hud_size_preference
    if size == SizePreferences["double"] or size == SizePreferences["largest"] then
        return len * 2
    else
        return len
    end
end

function handle_ending()
    if Game.ticks >= end_screen_start + 240 then
        if get_stashed_num("score_mission_status") >= 5 then
            if not animation_start then
                animation_start = Game.ticks
            end
            if Game.ticks >= animation_start + 340 then
                draw_end_screen()
            else
                show_end_animation()
            end
        else
            draw_end_screen()
        end
    else
        local end_image = end_images[get_stashed_num("score_mission_status")]
        local end_image_x = (Screen.width / 2) - (end_image.width / 2)
        local end_image_y = (Screen.height / 2) - (end_image.height / 2)
        end_image:draw(end_image_x, end_image_y)
    end
end

function show_end_animation()
    local x = (Screen.width / 2) - (end_animation_images[1].width / 2)
    local y = (Screen.height / 2) - (end_animation_images[1].height / 2)
    if Game.ticks < animation_start + 210 then
        end_animation_images[1]:draw(x, y)
    elseif Game.ticks < animation_start + 212 then
        end_animation_images[2]:draw(x, y)
    elseif Game.ticks < animation_start + 214 then
        end_animation_images[3]:draw(x, y)
    elseif Game.ticks < animation_start + 216 then
        end_animation_images[4]:draw(x, y)
    elseif Game.ticks < animation_start + 218 then
        end_animation_images[5]:draw(x, y)
    elseif Game.ticks < animation_start + 220 and Game.ticks <= animation_start + 222 then
        end_animation_images[6]:draw(x, y)
    end
end

function draw_end_screen()
    local mission_status = get_stashed_num("score_mission_status")
    local nightmares = get_stashed_num("score_nightmares")
    local headlesses = get_stashed_num("score_headlesses")
    local phantasms = get_stashed_num("score_phantasms")
    local ghouls = get_stashed_num("score_ghouls")
    local zombies = get_stashed_num("score_zombies")
    local oozes = get_stashed_num("score_oozes")
    local wraiths = get_stashed_num("score_wraiths")
    local shocking_spheres = get_stashed_num("score_shocking_spheres")
    local skitters = get_stashed_num("score_skitters")
    local sentinels = get_stashed_num("score_sentinels")
    local ghasts = get_stashed_num("score_ghasts")
    local greater_nightmares = get_stashed_num("score_greater_nightmares")
    local venemous_skitters = get_stashed_num("score_venemous_skitters")
    local damage_inflicted = get_stashed_num("score_damage_inflicted")
    local damage_taken = get_stashed_num("score_damage_taken")
    local melee_shots = get_stashed_num("score_melee_shots")
    local melee_hits = get_stashed_num("score_melee_hits")
    local p4_shots = get_stashed_num("score_p4_shots")
    local p4_hits = get_stashed_num("score_p4_hits")
    local smg_shots = get_stashed_num("score_smg_shots")
    local smg_hits = get_stashed_num("score_smg_hits")
    local ar_shots = get_stashed_num("score_ar_shots")
    local ar_hits = get_stashed_num("score_ar_hits")
    local grenade_shots = get_stashed_num("score_grenade_shots")
    local grenade_hits = get_stashed_num("score_grenade_hits")
    local treasure_bonus = get_stashed_num("score_treasure_bonus")
    local time_bonus = get_stashed_num("score_time_bonus")
    local difficulty_average = get_stashed_num("score_difficulty_average")
    local points = get_stashed_num("score_points")

    local score_window_x = (Screen.width / 2) - (score_image.width / 2)
    local score_window_y = (Screen.height / 2) - (score_image.height / 2)
    score_image:draw(score_window_x, score_window_y)

    -- Body Count

    local f = int_fonts["network statistics"]
    local body_count_y = score_window_y + 59
    if nightmares > 0 then
        f:draw_text("Nightmare", score_window_x + 27, body_count_y, {0, 0, 0, 1})
        f:draw_text(nightmares, right_align(nightmares, score_window_x + 202), body_count_y, {0, 0, 0, 1})
        body_count_y = body_count_y + 12
    end
    if headlesses > 0 then
        f:draw_text("Headless", score_window_x + 27, body_count_y, {0, 0, 0, 1})
        f:draw_text(headlesses, right_align(headlesses, score_window_x + 202), body_count_y, {0, 0, 0, 1})
        body_count_y = body_count_y + 12
    end
    if phantasms > 0 then
        f:draw_text("Phantasm", score_window_x + 27, body_count_y, {0, 0, 0, 1})
        f:draw_text(phantasms, right_align(phantasms, score_window_x + 202), body_count_y, {0, 0, 0, 1})
        body_count_y = body_count_y + 12
    end
    if ghouls > 0 then
        f:draw_text("Ghoul", score_window_x + 27, body_count_y, {0, 0, 0, 1})
        f:draw_text(ghouls, right_align(ghouls, score_window_x + 202), body_count_y, {0, 0, 0, 1})
        body_count_y = body_count_y + 12
    end
    if zombies > 0 then
        f:draw_text("Zombie", score_window_x + 27, body_count_y, {0, 0, 0, 1})
        f:draw_text(zombies, right_align(zombies, score_window_x + 202), body_count_y, {0, 0, 0, 1})
        body_count_y = body_count_y + 12
    end
    if oozes > 0 then
        f:draw_text("Ooze", score_window_x + 27, body_count_y, {0, 0, 0, 1})
        f:draw_text(oozes, right_align(oozes, score_window_x + 202), body_count_y, {0, 0, 0, 1})
        body_count_y = body_count_y + 12
    end
    if wraiths > 0 then
        f:draw_text("Invisible Wraith", score_window_x + 27, body_count_y, {0, 0, 0, 1})
        f:draw_text(wraiths, right_align(wraiths, score_window_x + 202), body_count_y, {0, 0, 0, 1})
        body_count_y = body_count_y + 12
    end
    if shocking_spheres > 0 then
        f:draw_text("Shocking Sphere", score_window_x + 27, body_count_y, {0, 0, 0, 1})
        f:draw_text(shocking_spheres, right_align(shocking_spheres, score_window_x + 202), body_count_y, {0, 0, 0, 1})
        body_count_y = body_count_y + 12
    end
    if skitters > 0 then
        f:draw_text("Skitter", score_window_x + 27, body_count_y, {0, 0, 0, 1})
        f:draw_text(skitters, right_align(skitters, score_window_x + 202), body_count_y, {0, 0, 0, 1})
        body_count_y = body_count_y + 12
    end
    if sentinels > 0 then
        f:draw_text("Sentinel", score_window_x + 27, body_count_y, {0, 0, 0, 1})
        f:draw_text(sentinels, right_align(sentinels, score_window_x + 202), body_count_y, {0, 0, 0, 1})
        body_count_y = body_count_y + 12
    end
    if ghasts > 0 then
        f:draw_text("Ghast", score_window_x + 27, body_count_y, {0, 0, 0, 1})
        f:draw_text(ghasts, right_align(ghasts, score_window_x + 202), body_count_y, {0, 0, 0, 1})
        body_count_y = body_count_y + 12
    end
    if greater_nightmares > 0 then
        f:draw_text("Greater Nightmare", score_window_x + 27, body_count_y, {0, 0, 0, 1})
        f:draw_text(
            greater_nightmares,
            right_align(greater_nightmares, score_window_x + 202),
            body_count_y,
            {0, 0, 0, 1}
        )
        body_count_y = body_count_y + 12
    end
    if venemous_skitters > 0 then
        f:draw_text("Venemous Skitter", score_window_x + 27, body_count_y, {0, 0, 0, 1})
        f:draw_text(venemous_skitters, right_align(venemous_skitters, score_window_x + 202), body_count_y, {0, 0, 0, 1})
        body_count_y = body_count_y + 12
    end

    local body_count_total =
        nightmares + headlesses + phantasms + ghouls + zombies + oozes + wraiths + shocking_spheres + skitters +
        sentinels +
        ghasts +
        greater_nightmares +
        venemous_skitters

    body_count_y = body_count_y + 12
    f:draw_text("Body Count", score_window_x + 27, body_count_y, {0, 0, 0, 1})
    f:draw_text(body_count_total, right_align(body_count_total, score_window_x + 202), body_count_y, {0, 0, 0, 1})

    -- Damage
    local damage_y = score_window_y + 281

    f:draw_text("Damage Inflicted", score_window_x + 27, damage_y, {0, 0, 0, 1})
    f:draw_text(damage_inflicted, right_align(damage_inflicted, score_window_x + 202), damage_y, {0, 0, 0, 1})
    damage_y = damage_y + 12

    f:draw_text("Damage Taken", score_window_x + 27, damage_y, {0, 0, 0, 1})
    f:draw_text(damage_taken, right_align(damage_taken, score_window_x + 202), damage_y, {0, 0, 0, 1})
    damage_y = damage_y + 24

    if damage_taken > 0 then
        local ratio = round(damage_inflicted / damage_taken, 2)
        f:draw_text("Damage Ratio", score_window_x + 27, damage_y, {0, 0, 0, 1})
        f:draw_text(ratio, right_align(ratio, score_window_x + 202), damage_y, {0, 0, 0, 1})
    end

    -- Accuracy
    local accuracy_y = score_window_y + 59
    local total_shots = 0
    local total_hits = 0

    if melee_shots > 0 then
        total_shots = total_shots + melee_shots
        total_hits = total_hits + melee_hits
        f:draw_text("Survival Knife", score_window_x + 232, accuracy_y, {0, 0, 0, 1})

        local percent = math.floor((melee_hits / melee_shots) * 100)
        local text = percent .. "% (" .. melee_hits .. "/" .. melee_shots .. ")"
        f:draw_text(text, right_align(text, score_window_x + 477), accuracy_y, {0, 0, 0, 1})
        accuracy_y = accuracy_y + 12
    end
    if p4_shots > 0 then
        total_shots = total_shots + p4_shots
        total_hits = total_hits + p4_hits
        f:draw_text("Walther P4 Pistol", score_window_x + 232, accuracy_y, {0, 0, 0, 1})

        local percent = math.floor((p4_hits / p4_shots) * 100)
        local text = percent .. "% (" .. p4_hits .. "/" .. p4_shots .. ")"
        f:draw_text(text, right_align(text, score_window_x + 477), accuracy_y, {0, 0, 0, 1})
        accuracy_y = accuracy_y + 12
    end
    if smg_shots > 0 then
        total_shots = total_shots + smg_shots
        total_hits = total_hits + smg_hits
        f:draw_text("MP-41 Submachine Gun", score_window_x + 232, accuracy_y, {0, 0, 0, 1})

        local percent = math.floor((smg_hits / smg_shots) * 100)
        local text = percent .. "% (" .. smg_hits .. "/" .. smg_shots .. ")"
        f:draw_text(text, right_align(text, score_window_x + 477), accuracy_y, {0, 0, 0, 1})
        accuracy_y = accuracy_y + 12
    end
    if ar_shots > 0 then
        total_shots = total_shots + ar_shots
        total_hits = total_hits + ar_hits
        f:draw_text("AK-47 Assault Rifle", score_window_x + 232, accuracy_y, {0, 0, 0, 1})

        local percent = math.floor((ar_hits / ar_shots) * 100)
        local text = percent .. "% (" .. ar_hits .. "/" .. ar_shots .. ")"
        f:draw_text(text, right_align(text, score_window_x + 477), accuracy_y, {0, 0, 0, 1})
        accuracy_y = accuracy_y + 12
    end
    if grenade_shots > 0 then
        total_shots = total_shots + grenade_shots
        total_hits = total_hits + grenade_hits
        f:draw_text("M-79 Grenade Launcher", score_window_x + 232, accuracy_y, {0, 0, 0, 1})

        local percent = math.floor((grenade_hits / grenade_shots) * 100)
        local text = percent .. "% (" .. grenade_hits .. "/" .. grenade_shots .. ")"
        f:draw_text(text, right_align(text, score_window_x + 477), accuracy_y, {0, 0, 0, 1})
        accuracy_y = accuracy_y + 12
    end

    local total_accuracy = 0
    if total_shots > 0 then
        accuracy_y = accuracy_y + 12
        f:draw_text("Overall Accuracy", score_window_x + 232, accuracy_y, {0, 0, 0, 1})

        total_accuracy = math.floor((total_hits / total_shots) * 100)
        local text = total_accuracy .. "%"
        f:draw_text(text, right_align(text, score_window_x + 477), accuracy_y, {0, 0, 0, 1})
    end

    -- Score
    local carnage_bonus = math.floor(body_count_total / 250)
    local accuracy_bonus = 0
    if total_accuracy > 40 then
        accuracy_bonus = math.floor((total_accuracy - 40) / 10)
    end
    local mission_bonus = 0
    if mission_status >= 3 then
        mission_bonus = 5
    end
    local survival_bonus = 0
    if mission_status >= 5 then
        survival_bonus = 10
    end

    local difficulty_bonus = 0
    if difficulty_average == 4 then
        difficulty_bonus = 2
    elseif difficulty_average == 5 then
        difficulty_bonus = 5
    elseif difficulty_average == 2 then
        difficulty_bonus = -2
    elseif difficulty_average == 1 then
        difficulty_bonus = -5
    end
    local total_score =
        points + carnage_bonus + accuracy_bonus + treasure_bonus + time_bonus + mission_bonus + survival_bonus +
        difficulty_bonus

    local score_y = score_window_y + 188
    f:draw_text("Carnage Bonus (+1 per 250 bodies)", score_window_x + 232, score_y, {0, 0, 0, 1})
    f:draw_text("+" .. carnage_bonus, right_align("+" .. carnage_bonus, score_window_x + 477), score_y, {0, 0, 0, 1})
    score_y = score_y + 12

    f:draw_text("Accuracy Bonus (+1 per 10% over 40%)", score_window_x + 232, score_y, {0, 0, 0, 1})
    f:draw_text("+" .. accuracy_bonus, right_align("+" .. accuracy_bonus, score_window_x + 477), score_y, {0, 0, 0, 1})
    score_y = score_y + 12

    if treasure_bonus > 0 then
        f:draw_text("Treasure Bonus (+1 per $100K)", score_window_x + 232, score_y, {0, 0, 0, 1})
        f:draw_text(
            "+" .. treasure_bonus,
            right_align("+" .. treasure_bonus, score_window_x + 477),
            score_y,
            {0, 0, 0, 1}
        )
        score_y = score_y + 12
    end

    if time_bonus > 0 then
        f:draw_text("Time Bonus (+1 per 10 hours left)", score_window_x + 232, score_y, {0, 0, 0, 1})
        f:draw_text("+" .. time_bonus, right_align("+" .. time_bonus, score_window_x + 477), score_y, {0, 0, 0, 1})
        score_y = score_y + 12
    end

    if mission_bonus > 0 then
        f:draw_text("Mission Bonus", score_window_x + 232, score_y, {0, 0, 0, 1})
        f:draw_text(
            "+" .. mission_bonus,
            right_align("+" .. mission_bonus, score_window_x + 477),
            score_y,
            {0, 0, 0, 1}
        )
        score_y = score_y + 12
    end

    if survival_bonus > 0 then
        f:draw_text("Survival Bonus", score_window_x + 232, score_y, {0, 0, 0, 1})
        f:draw_text(
            "+" .. survival_bonus,
            right_align("+" .. survival_bonus, score_window_x + 477),
            score_y,
            {0, 0, 0, 1}
        )
        score_y = score_y + 12
    end

    if difficulty_bonus < 0 then
        f:draw_text("Difficulty Penalty", score_window_x + 232, score_y, {0, 0, 0, 1})
        f:draw_text(
            "-" .. difficulty_bonus * -1,
            right_align("-" .. difficulty_bonus * -1, score_window_x + 477),
            score_y,
            {0, 0, 0, 1}
        )
        score_y = score_y + 12
    end

    if difficulty_bonus > 3 then
        f:draw_text("Difficulty Bonus", score_window_x + 232, score_y, {0, 0, 0, 1})
        f:draw_text(
            "+" .. difficulty_bonus,
            right_align("+" .. difficulty_bonus, score_window_x + 477),
            score_y,
            {0, 0, 0, 1}
        )
        score_y = score_y + 12
    end

    score_y = score_y + 12
    f:draw_text("Total Score", score_window_x + 232, score_y, {0, 0, 0, 1})
    f:draw_text(total_score, right_align(total_score, score_window_x + 477), score_y, {0, 0, 0, 1})
end

function right_align(text, x)
    return x - (string.len(text) * 6)
end

function right_align_adj(text, x)
    return x - adj(string.len(text) * 6)
end

function round(num, numDecimalPlaces)
    local mult = 10 ^ (numDecimalPlaces or 0)
    return math.floor(num * mult + 0.5) / mult
end

function get_stashed_num(key)
    local val = get_stashed(key)
    return tonumber(val)
end

function get_stashed(key)
    return Level.stash["__AOPID__" .. key]
end
